/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.actions;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.php.debug.ui.display.PHPInspectExpression;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class InspectAction
implements IWatchExpressionListener,
IInformationProvider,
IWorkbenchWindowActionDelegate,
IObjectActionDelegate,
IEditorActionDelegate {
    private static final String INSPECT_COMMAND_DEFINITION_ID = "com.aptana.php.debug.ui.command.Inspect";
    private ITextViewer viewer;

    public void watchEvaluationFinished(final IWatchExpressionResult result) {
        if (result == null || DebugUIPlugin.getDefault() == null) {
            return;
        }
        if (result.getValue() != null || result.hasErrors()) {
            DebugUIPlugin.getStandardDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    InspectAction.this.displayResult(result);
                }
            });
        }
    }

    protected void createExpression(IExpressionManager expressionManager, String expression) {
        IWatchExpression watchExpression = expressionManager.newWatchExpression(expression.trim());
        watchExpression.setExpressionContext(this.getContext());
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return "";
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        Point p = this.viewer.getSelectedRange();
        return new Region(p.x, p.y);
    }

    private void showPopup(IWatchExpressionResult result) {
        PHPInspectExpression expression = new PHPInspectExpression(result);
        InspectPopupDialog inspectDialog = new InspectPopupDialog(this.getShell(), this.getAnchor(), INSPECT_COMMAND_DEFINITION_ID, (IExpression)expression);
        inspectDialog.open();
    }

    private IWorkbenchPart getWorkbenchPart() {
        return DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
    }

    private Shell getShell() {
        IWorkbenchPart workbenchPart = this.getWorkbenchPart();
        if (workbenchPart != null) {
            return workbenchPart.getSite().getShell();
        }
        return DebugUIPlugin.getShell();
    }

    public void run(IAction action) {
        IDebugElement context;
        IWorkbenchPage page;
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null && (page = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage()) != null) {
            selection = page.getSelection();
        }
        if ((context = this.getContext()) != null && selection instanceof TextSelection) {
            try {
                TextSelection textSelection = (TextSelection)selection;
                IExpressionManager expressionManager = DebugPlugin.getDefault().getExpressionManager();
                IWatchExpressionDelegate delegate = expressionManager.newWatchExpressionDelegate(context.getModelIdentifier());
                if (delegate != null) {
                    delegate.evaluateExpression(textSelection.getText(), context, (IWatchExpressionListener)this);
                } else {
                    this.watchEvaluationFinished(null);
                }
            }
            catch (Exception e) {
                PHPDebugEPLPlugin.logError(e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            action.setEnabled(textSelection.getLength() != 0);
        }
    }

    public void init(IWorkbenchWindow window) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void dispose() {
    }

    protected void displayResult(IWatchExpressionResult result) {
        if (result == null) {
            return;
        }
        IWorkbenchPart part = this.getWorkbenchPart();
        this.viewer = (ITextViewer)part.getAdapter(ITextViewer.class);
        if (this.viewer == null && part instanceof AbstractThemeableEditor) {
            this.viewer = ((AbstractThemeableEditor)part).getISourceViewer();
        }
        if (this.viewer != null) {
            this.showPopup(result);
        }
    }

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchPage page = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected IDebugElement getContext() {
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        return context;
    }

    private Point getAnchor() {
        StyledText styledText = this.viewer.getTextWidget();
        Point selection = styledText.getSelectionRange();
        int mid = selection.x + selection.y / 2;
        Point locationAtOffset = styledText.getLocationAtOffset(mid);
        locationAtOffset = styledText.toDisplay(locationAtOffset);
        GC gc = new GC((Drawable)styledText);
        gc.setFont(styledText.getFont());
        int height = gc.getFontMetrics().getHeight();
        locationAtOffset.y += height;
        gc.dispose();
        return locationAtOffset;
    }
}

